/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class FadeAwayEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent FILTER_CREATURE = new FilterCreaturePermanent();

    FadeAwayEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "For each creature, its controller sacrifices a permanent unless they pay {1}";
    }

    private FadeAwayEffect(FadeAwayEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int creaturesNumber = game.getBattlefield().getAllActivePermanents((FilterPermanent)FILTER_CREATURE, playerId, game).size();
            if (creaturesNumber > 0) {
                int targetsNumber;
                String message = "For how many creatures will you pay (up to " + creaturesNumber + ")?";
                int payAmount = 0;
                boolean paid = false;
                while (player.canRespond() && !paid) {
                    payAmount = player.getAmount(0, creaturesNumber, message, source, game);
                    ManaCostsImpl cost = new ManaCostsImpl();
                    cost.add((ManaCost)new GenericManaCost(payAmount));
                    cost.clearPaid();
                    if (!cost.payOrRollback(source, game, source, playerId)) continue;
                    paid = true;
                }
                int sacrificeNumber = creaturesNumber - payAmount;
                game.informPlayers(player.getLogName() + " pays {" + payAmount + "} and sacrifices " + sacrificeNumber + " permanent" + (sacrificeNumber == 1 ? "" : "s"));
                if (sacrificeNumber <= 0) continue;
                int permanentsNumber = game.getBattlefield().getAllActivePermanents(playerId).size();
                TargetSacrifice target = new TargetSacrifice(targetsNumber, (targetsNumber = Math.min(sacrificeNumber, permanentsNumber)) == 1 ? StaticFilters.FILTER_PERMANENT : StaticFilters.FILTER_PERMANENTS);
                player.choose(Outcome.Sacrifice, (Target)target, source, game);
                for (UUID permanentId : target.getTargets()) {
                    Permanent permanent = game.getPermanent(permanentId);
                    if (permanent == null) continue;
                    permanent.sacrifice(source, game);
                }
                continue;
            }
            game.informPlayers(player.getLogName() + " has no creatures");
        }
        return true;
    }

    public FadeAwayEffect copy() {
        return new FadeAwayEffect(this);
    }
}

