/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.hint.Hint;
import mage.game.Game;
import mage.watchers.common.SpellsCastWatcher;

enum FaeOfferingHint implements Hint
{
    instance;


    public String getText(Game game, Ability ability) {
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (watcher == null) {
            return null;
        }
        List spells = watcher.getSpellsCastThisTurn(ability.getControllerId());
        if (spells == null) {
            return null;
        }
        List messages = spells.stream().filter(Objects::nonNull).map(spell -> spell.isCreature(game)).distinct().map(b -> b != false ? "Creature spell" : "Noncreature spell").sorted().collect(Collectors.toList());
        if (messages.isEmpty()) {
            return "You have not cast any spells this turn";
        }
        return "You have cast a " + String.join((CharSequence)" and a ", messages) + " this turn";
    }

    public FaeOfferingHint copy() {
        return instance;
    }
}

