/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FaeburrowElderManaEffect
extends ManaEffect {
    FaeburrowElderManaEffect() {
        this.staticText = "For each color among permanents you control, add one mana of that color";
    }

    private FaeburrowElderManaEffect(FaeburrowElderManaEffect effect) {
        super((ManaEffect)effect);
    }

    public FaeburrowElderManaEffect copy() {
        return new FaeburrowElderManaEffect(this);
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (mana.getBlack() == 0 && permanent.getColor(game).isBlack()) {
                mana.increaseBlack();
            }
            if (mana.getBlue() == 0 && permanent.getColor(game).isBlue()) {
                mana.increaseBlue();
            }
            if (mana.getRed() == 0 && permanent.getColor(game).isRed()) {
                mana.increaseRed();
            }
            if (mana.getGreen() == 0 && permanent.getColor(game).isGreen()) {
                mana.increaseGreen();
            }
            if (mana.getWhite() != 0 || !permanent.getColor(game).isWhite()) continue;
            mana.increaseWhite();
        }
        return mana;
    }
}

