/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.f.ControlledFaerieAsSpellCastWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class FaerieFencingEffect
extends OneShotEffect {
    FaerieFencingEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "target creature gets -X/-X until end of turn. That creature gets an additional -3/-3 until end of turn if you controlled a Faerie as you cast this spell.";
    }

    private FaerieFencingEffect(FaerieFencingEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ControlledFaerieAsSpellCastWatcher watcher = (ControlledFaerieAsSpellCastWatcher)game.getState().getWatcher(ControlledFaerieAsSpellCastWatcher.class);
        MageObject mo = source.getSourceObject(game);
        int reduction = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (watcher != null && mo != null && watcher.getCount(new MageObjectReference(mo, game)) > 0) {
            reduction += 3;
        }
        game.addEffect((ContinuousEffect)new BoostTargetEffect(-reduction, -reduction, Duration.EndOfTurn), source);
        return true;
    }

    public FaerieFencingEffect copy() {
        return new FaerieFencingEffect(this);
    }
}

