/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Objects;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandFromBattlefieldAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.token.FaerieBlockFliersToken;

class FaerieSlumberPartyEffect
extends OneShotEffect {
    FaerieSlumberPartyEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return all creatures to their owners' hands. For each opponent who controlled a creature returned this way, you create two 1/1 blue Faerie creature tokens with flying and \"This creature can block only creatures with flying.\"";
    }

    private FaerieSlumberPartyEffect(FaerieSlumberPartyEffect effect) {
        super((OneShotEffect)effect);
    }

    public FaerieSlumberPartyEffect copy() {
        return new FaerieSlumberPartyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set opponents = game.getOpponents(source.getControllerId());
        int count = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game).stream().filter(Objects::nonNull).map(Controllable::getControllerId).distinct().filter(opponents::contains).mapToInt(id -> 1).sum();
        if (!new ReturnToHandFromBattlefieldAllEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE).apply(game, source)) {
            return false;
        }
        if (count > 0) {
            FaerieBlockFliersToken token = new FaerieBlockFliersToken();
            token.putOntoBattlefield(2 * count, game, source, source.getControllerId());
        }
        return true;
    }
}

