/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class FairgroundsTrumpeterWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    public FairgroundsTrumpeterWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.COUNTER_ADDED && event.getData().equals(CounterType.P1P1.getName())) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (permanent == null) {
                permanent = game.getPermanentEntering(event.getTargetId());
            }
            if (permanent != null) {
                this.players.add(permanent.getControllerId());
            }
        }
    }

    public void reset() {
        this.players.clear();
    }

    public boolean p1p1AddedToPermanent(UUID playerId) {
        return this.players.contains(playerId);
    }
}

