/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class FaithsFettersEffect
extends ContinuousRuleModifyingEffectImpl {
    FaithsFettersEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "and its activated abilities can't be activated unless they're mana abilities";
    }

    private FaithsFettersEffect(FaithsFettersEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public FaithsFettersEffect copy() {
        return new FaithsFettersEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.isAttachedTo(event.getSourceId())) {
            Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
            return ability.isPresent() && ((Ability)ability.get()).isNonManaActivatedAbility();
        }
        return false;
    }
}

