/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPlayer;

class FalkenrathNobleTriggeredAbility
extends TriggeredAbilityImpl {
    public FalkenrathNobleTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(1), false);
        this.addEffect((Effect)new GainLifeEffect(1));
        this.addTarget((Target)new TargetPlayer());
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private FalkenrathNobleTriggeredAbility(FalkenrathNobleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FalkenrathNobleTriggeredAbility copy() {
        return new FalkenrathNobleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent()) {
            return false;
        }
        Permanent permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD);
        if (permanent == null) {
            return false;
        }
        if (permanent.getId().equals(this.getSourceId())) {
            return true;
        }
        return permanent.isCreature(game);
    }

    public String getRule() {
        return "Whenever {this} or another creature dies, target player loses 1 life and you gain 1 life.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

