/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FangsOfKaloniaOverloadEffect
extends OneShotEffect {
    FangsOfKaloniaOverloadEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on each creature you control, then double the number of +1/+1 counters on each creature that had a +1/+1 counter put on it this way";
    }

    private FangsOfKaloniaOverloadEffect(FangsOfKaloniaOverloadEffect effect) {
        super((OneShotEffect)effect);
    }

    public FangsOfKaloniaOverloadEffect copy() {
        return new FangsOfKaloniaOverloadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game).stream().filter(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(), source, game)).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        for (Permanent permanent2 : permanents) {
            permanent2.addCounters(CounterType.P1P1.createInstance(permanent2.getCounters(game).getCount(CounterType.P1P1)), source.getControllerId(), source, game);
        }
        return true;
    }
}

