/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class FarFortuneEndBossEffect
extends ReplacementEffectImpl {
    FarFortuneEndBossEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a source you control would deal damage to an opponent or a permanent an opponent controls, it deals that much damage plus 1 instead";
    }

    private FarFortuneEndBossEffect(FarFortuneEndBossEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FarFortuneEndBossEffect copy() {
        return new FarFortuneEndBossEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.isControlledBy(game.getControllerId(event.getSourceId()))) {
            return false;
        }
        Set opponents = game.getOpponents(source.getControllerId());
        return opponents.contains(event.getTargetId()) && opponents.contains(game.getControllerId(event.getTargetId()));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

