/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.TargetAdjuster;

enum FatalLoreAdjuster implements TargetAdjuster
{
    instance;


    public void adjustTargets(Ability ability, Game game) {
        Mode mode = ability.getModes().getMode();
        if (mode.getEffects().stream().noneMatch(DestroyTargetEffect.class::isInstance)) {
            return;
        }
        UUID playerId = mode.getEffects().stream().findFirst().filter(Objects::nonNull).map(effect -> (UUID)effect.getValue("choosingPlayer")).orElse(null);
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures controlled by " + game.getPlayer(playerId).getName());
        filter.add((Predicate)new ControllerIdPredicate(playerId));
        mode.getTargets().clear();
        mode.addTarget((Target)new TargetPermanent(0, 2, (FilterPermanent)filter));
    }
}

