/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.condition.common.RevoltCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FatalPushEffect
extends OneShotEffect {
    FatalPushEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature if it has mana value 2 or less.<br>" + AbilityWord.REVOLT.formatWord() + "Destroy that creature if it has mana value 4 or less instead if a permanent left the battlefield under your control this turn";
    }

    private FatalPushEffect(FatalPushEffect effect) {
        super((OneShotEffect)effect);
    }

    public FatalPushEffect copy() {
        return new FatalPushEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature == null) {
            return false;
        }
        int cmc = targetCreature.getManaValue();
        return (cmc <= 2 || RevoltCondition.instance.apply(game, source) && cmc <= 4) && targetCreature.destroy(source, game, false);
    }
}

