/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FatefulHandoffControlEffect
extends ContinuousEffectImpl {
    private final UUID permanentId;
    private final UUID opponentId;

    public FatefulHandoffControlEffect(UUID permanentId, UUID opponentId) {
        super(Duration.EndOfGame, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.permanentId = permanentId;
        this.opponentId = opponentId;
    }

    private FatefulHandoffControlEffect(FatefulHandoffControlEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.permanentId = effect.permanentId;
        this.opponentId = effect.opponentId;
    }

    public FatefulHandoffControlEffect copy() {
        return new FatefulHandoffControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.opponentId);
        Permanent permanent = game.getPermanent(this.permanentId);
        if (opponent != null && permanent != null) {
            permanent.changeControllerId(this.opponentId, game, source);
        } else {
            this.discard();
        }
        return true;
    }
}

