/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FearOfImmobilityEffect
extends OneShotEffect {
    FearOfImmobilityEffect() {
        super(Outcome.Benefit);
        this.staticText = "If an opponent controls that creature, put a stun counter on it";
    }

    private FearOfImmobilityEffect(FearOfImmobilityEffect effect) {
        super((OneShotEffect)effect);
    }

    public FearOfImmobilityEffect copy() {
        return new FearOfImmobilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return permanent != null && game.getOpponents(source.getControllerId()).contains(permanent.getControllerId()) && permanent.addCounters(CounterType.STUN.createInstance(), source, game);
    }
}

