/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FeintEffect
extends OneShotEffect {
    FeintEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "tap all creatures blocking target attacking creature";
    }

    private FeintEffect(FeintEffect effect) {
        super((OneShotEffect)effect);
    }

    public FeintEffect copy() {
        return new FeintEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && creature != null) {
            for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                if (!combatGroup.getAttackers().contains(creature.getId())) continue;
                for (UUID blockerId : combatGroup.getBlockers()) {
                    Permanent blocker = game.getPermanent(blockerId);
                    if (blocker == null) continue;
                    blocker.tap(source, game);
                    PreventDamageByTargetEffect effect = new PreventDamageByTargetEffect(Duration.EndOfTurn, true);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(blocker.getId(), game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

