/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TapAllEffect;
import mage.abilities.effects.common.combat.GoadAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class FellBeastsShriekEffect
extends OneShotEffect {
    FellBeastsShriekEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent chooses a creature they control. Tap and goad the chosen creatures.";
    }

    private FellBeastsShriekEffect(FellBeastsShriekEffect effect) {
        super((OneShotEffect)effect);
    }

    public FellBeastsShriekEffect copy() {
        return new FellBeastsShriekEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Permanent> creaturesChosen = new ArrayList<Permanent>();
        for (UUID playerId : game.getOpponents(controller.getId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            if (!opponent.choose(Outcome.Detriment, (Target)target, source, game)) continue;
            creaturesChosen.add(game.getPermanent((UUID)target.getTargets().get(0)));
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PermanentReferenceInCollectionPredicate(creaturesChosen, game));
        new TapAllEffect((FilterPermanent)filter).apply(game, source);
        GoadAllEffect goadEffect = new GoadAllEffect((FilterPermanent)filter);
        game.addEffect((ContinuousEffect)goadEffect, source);
        return true;
    }
}

