/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class FeralContestEffect
extends RequirementEffect {
    FeralContestEffect() {
        this(Duration.EndOfTurn);
    }

    public FeralContestEffect(Duration duration) {
        super(duration);
        this.staticText = "Another target creature blocks it this turn if able";
    }

    private FeralContestEffect(FeralContestEffect effect) {
        super((RequirementEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(((Target)source.getTargets().get(1)).getFirstTarget())) {
            return permanent.canBlock(source.getFirstTarget(), game);
        }
        return false;
    }

    public boolean mustAttack(Game game) {
        return false;
    }

    public boolean mustBlock(Game game) {
        return true;
    }

    public UUID mustBlockAttacker(Ability source, Game game) {
        return source.getFirstTarget();
    }

    public FeralContestEffect copy() {
        return new FeralContestEffect(this);
    }
}

