/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Duration;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class FeralEncounterEffect
extends LookLibraryAndPickControllerEffect {
    FeralEncounterEffect() {
        super(5, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, PutCards.EXILED, PutCards.BOTTOM_RANDOM);
        this.staticText = "look at the top five cards of your library. You may exile a creature card from among them. Put the rest on the bottom of your library in a random order. You may cast the exiled card this turn";
    }

    private FeralEncounterEffect(FeralEncounterEffect effect) {
        super((LookLibraryAndPickControllerEffect)effect);
    }

    public FeralEncounterEffect copy() {
        return new FeralEncounterEffect(this);
    }

    protected boolean actionWithPickedCards(Game game, Ability source, Player player, Cards pickedCards, Cards otherCards) {
        boolean result = this.putPickedCards.moveCards(player, pickedCards, source, game);
        pickedCards.retainZone(Zone.EXILED, game);
        for (Card card : pickedCards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)false);
        }
        return result |= this.putLookedCards.moveCards(player, otherCards, source, game);
    }
}

