/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class FertileThicketEffect
extends OneShotEffect {
    FertileThicketEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may look at the top five cards of your library. If you do, reveal up to one basic land card from among them, then put that card on top of your library and the rest on the bottom in any order";
    }

    private FertileThicketEffect(FertileThicketEffect effect) {
        super((OneShotEffect)effect);
    }

    public FertileThicketEffect copy() {
        return new FertileThicketEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
            controller.lookAtCards(sourceObject.getIdName(), (Cards)cards, game);
            TargetCard target = new TargetCard(0, 1, Zone.LIBRARY, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
            controller.chooseTarget(this.outcome, (Cards)cards, target, source, game);
            CardsImpl cardsRevealed = new CardsImpl((Collection)target.getTargets());
            if (!cardsRevealed.isEmpty()) {
                controller.revealCards(sourceObject.getIdName(), (Cards)cardsRevealed, game);
                cards.removeAll((Collection)cardsRevealed);
                controller.putCardsOnTopOfLibrary((Cards)cardsRevealed, game, source, true);
            }
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
            return true;
        }
        return false;
    }
}

