/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class FeveredVisionsEffect
extends OneShotEffect {
    FeveredVisionsEffect() {
        super(Outcome.DrawCard);
        this.staticText = "that player draws a card. If the player is your opponent and has four or more cards in hand, {this} deals 2 damage to that player";
    }

    private FeveredVisionsEffect(FeveredVisionsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        UUID activePlayerId = game.getActivePlayerId();
        Player player = game.getPlayer(activePlayerId);
        if (controller != null && player != null) {
            player.drawCards(1, source, game);
            Set opponents = game.getOpponents(source.getControllerId());
            if (opponents.contains(player.getId()) && player.getHand().size() > 3) {
                player.damage(2, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public FeveredVisionsEffect copy() {
        return new FeveredVisionsEffect(this);
    }
}

