/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;
import mage.util.CardUtil;

class FiendOfTheShadowsEffect
extends OneShotEffect {
    FiendOfTheShadowsEffect() {
        super(Outcome.Discard);
        this.staticText = "that player exiles a card from their hand. You may play that card for as long as it remains exiled";
    }

    private FiendOfTheShadowsEffect(FiendOfTheShadowsEffect effect) {
        super((OneShotEffect)effect);
    }

    public FiendOfTheShadowsEffect copy() {
        return new FiendOfTheShadowsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        TargetDiscard targetCard = new TargetDiscard(player.getId());
        player.choose(this.outcome, (Target)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCardToExileWithInfo(card, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source), source, game, Zone.HAND, true);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.Custom, (boolean)false);
        return true;
    }
}

