/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class FiendslayerPaladinEffect
extends ContinuousRuleModifyingEffectImpl {
    FiendslayerPaladinEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "{this} can't be the target of black or red spells your opponents control";
    }

    private FiendslayerPaladinEffect(FiendslayerPaladinEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public FiendslayerPaladinEffect copy() {
        return new FiendslayerPaladinEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            return sourcePermanent.getLogName() + " can't be the target of black or red spells opponents control";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card targetCard = game.getCard(event.getTargetId());
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        return targetCard != null && stackObject != null && targetCard.getId().equals(source.getSourceId()) && (stackObject.getColor(game).isBlack() || stackObject.getColor(game).isRed()) && (!stackObject.isControlledBy(source.getControllerId()) && stackObject.isInstant(game) || stackObject.isSorcery(game));
    }
}

