/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FighterClassRequirementEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FighterClassEffect
extends OneShotEffect {
    FighterClassEffect() {
        super(Outcome.Benefit);
        this.staticText = "up to one target creature blocks it this combat if able";
    }

    private FighterClassEffect(FighterClassEffect effect) {
        super((OneShotEffect)effect);
    }

    public FighterClassEffect copy() {
        return new FighterClassEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObjectReference attackerRef = (MageObjectReference)this.getValue("attackerRef");
        if (attackerRef == null) {
            return false;
        }
        Permanent attacker = attackerRef.getPermanent(game);
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (attacker == null || permanent == null) {
            return false;
        }
        game.addEffect(new FighterClassRequirementEffect(attackerRef).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

