/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.abilities.keyword.ProtectionFromEachOpponentAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FigureOfFableSoldierEffect
extends OneShotEffect {
    FigureOfFableSoldierEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Soldier, it becomes a Kithkin Avatar with base power and toughness 7/8 and protection from each of your opponents";
    }

    private FigureOfFableSoldierEffect(FigureOfFableSoldierEffect effect) {
        super((OneShotEffect)effect);
    }

    public FigureOfFableSoldierEffect copy() {
        return new FigureOfFableSoldierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.SOLDIER, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.Custom, new SubType[]{SubType.KITHKIN, SubType.AVATAR}), source);
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(7, 8, Duration.Custom), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new ProtectionFromEachOpponentAbility(), Duration.Custom), source);
        return true;
    }
}

