/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class FinalActEffect
extends OneShotEffect {
    FinalActEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent loses all counters";
    }

    private FinalActEffect(FinalActEffect effect) {
        super((OneShotEffect)effect);
    }

    public FinalActEffect copy() {
        return new FinalActEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.loseAllCounters(source, game);
        }
        return true;
    }
}

