/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class FinaleOfEternityEffect
extends OneShotEffect {
    FinaleOfEternityEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "If X is 10 or more, return all creature cards from your graveyard to the battlefield.";
    }

    private FinaleOfEternityEffect(FinaleOfEternityEffect effect) {
        super((OneShotEffect)effect);
    }

    public FinaleOfEternityEffect copy() {
        return new FinaleOfEternityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0) < 10) {
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return player.moveCards(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game), Zone.BATTLEFIELD, source, game);
    }
}

