/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.cards.Card;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FinaleOfPromiseEffect
extends OneShotEffect {
    FinaleOfPromiseEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "You may cast up to one target instant card and/or up to one target sorcery card from your graveyard each with mana value X or less without paying their mana costs. If a card cast this way would be put into your graveyard this turn, exile it instead. If X is 10 or more, copy each of those spells twice. You may choose new targets for the copies.";
    }

    private FinaleOfPromiseEffect(FinaleOfPromiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public FinaleOfPromiseEffect copy() {
        return new FinaleOfPromiseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<UUID> cardsToCast = new ArrayList<UUID>();
        for (Target target : source.getTargets()) {
            for (UUID id : target.getTargets()) {
                if (id == null || cardsToCast.contains(id)) continue;
                cardsToCast.add(id);
            }
        }
        if (cardsToCast.size() > 1) {
            String cardsOrder = cardsToCast.stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).map(MageObject::getName).collect(Collectors.joining(" -> "));
            if (!controller.chooseUse(Outcome.Detriment, "Cast cards by choose order: " + (String)cardsOrder + "?", "Finale of Promise", "Use that order", "Reverse", source, game)) {
                Collections.reverse(cardsToCast);
            }
        }
        for (UUID id : cardsToCast) {
            Card card = game.getCard(id);
            if (card == null) continue;
            new MayCastTargetCardEffect(CastManaAdjustment.WITHOUT_PAYING_MANA_COST, true).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
        }
        int xValue = GetXValue.instance.calculate(game, source, null);
        if (xValue >= 10) {
            for (UUID id : cardsToCast) {
                Spell spell;
                Card card = game.getCard(id);
                if (card == null || (spell = game.getStack().getSpell(card.getId())) == null) continue;
                spell.createCopyOnStack(game, source, controller.getId(), true, 2);
            }
        }
        return true;
    }
}

