/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapLandsEffect;
import mage.abilities.effects.common.continuous.MaximumHandSizeControllerEffect;
import mage.cards.Cards;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class FinaleOfRevelationEffect
extends OneShotEffect {
    FinaleOfRevelationEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw X cards. If X is 10 or more, instead shuffle your graveyard into your library, draw X cards, untap up to five lands, and you have no maximum hand size for the rest of the game";
    }

    private FinaleOfRevelationEffect(FinaleOfRevelationEffect effect) {
        super((OneShotEffect)effect);
    }

    public FinaleOfRevelationEffect copy() {
        return new FinaleOfRevelationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue < 10) {
            player.drawCards(xValue, source, game);
        } else {
            player.putCardsOnTopOfLibrary((Cards)player.getGraveyard(), game, source, false);
            player.shuffleLibrary(source, game);
            player.drawCards(xValue, source, game);
            new UntapLandsEffect(5).apply(game, source);
            game.addEffect((ContinuousEffect)new MaximumHandSizeControllerEffect(Integer.MAX_VALUE, Duration.EndOfGame, MaximumHandSizeControllerEffect.HandSizeModification.SET), source);
        }
        return true;
    }
}

