/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FireGiantsFuryDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FireGiantsFuryEffect
extends OneShotEffect {
    FireGiantsFuryEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Whenever it deals combat damage to a player this turn, exile that many cards from the top of your library. Until the end of your next turn, you may play those cards";
    }

    private FireGiantsFuryEffect(FireGiantsFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public FireGiantsFuryEffect copy() {
        return new FireGiantsFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new FireGiantsFuryDelayedTriggeredAbility(new MageObjectReference((MageObject)permanent, game)), source);
        return true;
    }
}

