/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class FireLordZukoTriggeredAbility
extends TriggeredAbilityImpl {
    FireLordZukoTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersAllEffect(CounterType.P1P1.createInstance(), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE));
        this.setTriggerPhrase("Whenever you cast a spell from exile and whenever a permanent you control enters from exile, ");
    }

    private FireLordZukoTriggeredAbility(FireLordZukoTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FireLordZukoTriggeredAbility copy() {
        return new FireLordZukoTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                return Zone.EXILED.match(((EntersTheBattlefieldEvent)event).getFromZone());
            }
            case SPELL_CAST: {
                return Optional.ofNullable(game.getSpell(event.getTargetId())).map(Spell::getFromZone).filter(arg_0 -> ((Zone)Zone.EXILED).match(arg_0)).isPresent();
            }
        }
        return false;
    }
}

