/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class FireProphecyEffect
extends OneShotEffect {
    FireProphecyEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may put a card from your hand on the bottom of your library. If you do, draw a card.";
    }

    private FireProphecyEffect(FireProphecyEffect effect) {
        super((OneShotEffect)effect);
    }

    public FireProphecyEffect copy() {
        return new FireProphecyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().isEmpty() || !player.chooseUse(this.outcome, "Put a card from your hand on the bottom of your library?", source, game)) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand();
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        if (player.putCardsOnBottomOfLibrary(card, game, source)) {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

