/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class FirefluxSquadEffect
extends OneShotEffect {
    FirefluxSquadEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile another target attacking creature you control. If you do, reveal cards from the top of your library until you reveal a creature card. Put that card onto the battlefield tapped and attacking and the rest on the bottom of your library in a random order.";
    }

    private FirefluxSquadEffect(FirefluxSquadEffect effect) {
        super((OneShotEffect)effect);
    }

    public FirefluxSquadEffect copy() {
        return new FirefluxSquadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        Card toBattlefield = null;
        CardsImpl cards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (card == null || !card.isCreature(game)) continue;
            toBattlefield = card;
            break;
        }
        player.revealCards(source, (Cards)cards, game);
        if (toBattlefield == null) {
            return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        player.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, true, false, true, null);
        permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)toBattlefield, (Game)game);
        if (permanent != null) {
            cards.remove(toBattlefield);
            game.getCombat().addAttackingCreature(permanent.getId(), game);
        }
        return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
    }
}

