/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.constants.Duration;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.events.GameEvent;

class FiresOfMountDoomDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final UUID cardId;

    public FiresOfMountDoomDelayedTriggeredAbility(UUID cardId) {
        super((Effect)new DamagePlayersEffect(2, TargetController.ANY), Duration.EndOfTurn);
        this.cardId = cardId;
    }

    private FiresOfMountDoomDelayedTriggeredAbility(FiresOfMountDoomDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.cardId = ability.cardId;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        GameEvent.EventType type = event.getType();
        return type == GameEvent.EventType.PLAY_LAND || type == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.hasApprovingIdentifier(MageIdentifier.FiresOfMountDoomAlternateCast)) {
            return false;
        }
        return event.getSourceId().equals(this.cardId);
    }

    public FiresOfMountDoomDelayedTriggeredAbility copy() {
        return new FiresOfMountDoomDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When you play a card this way, {this} deals 2 damage to each player";
    }
}

