/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.common.TargetCreatureOrPlayer;

class FiresongAndSunspeakerTriggeredAbility
extends TriggeredAbilityImpl {
    public FiresongAndSunspeakerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(3), false);
        this.addTarget((Target)new TargetCreatureOrPlayer());
    }

    private FiresongAndSunspeakerTriggeredAbility(FiresongAndSunspeakerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FiresongAndSunspeakerTriggeredAbility copy() {
        return new FiresongAndSunspeakerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAINED_LIFE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        return object instanceof Spell && event.getTargetId().equals(this.getControllerId()) && object.getColor(game).contains(ObjectColor.WHITE) && (object.isInstant(game) || object.isSorcery(game));
    }

    public String getRule() {
        return "Whenever a white instant or sorcery spell causes you to gain life, {this} deals 3 damage to target creature or player.";
    }
}

