/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FirestormEffect
extends OneShotEffect {
    FirestormEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage to each of X targets";
    }

    private FirestormEffect(FirestormEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        int amount = GetXValue.instance.calculate(game, source, (Effect)this);
        if (you != null) {
            if (!source.getTargets().isEmpty()) {
                for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                    Permanent creature = game.getPermanent(targetId);
                    if (creature != null) {
                        creature.damage(amount, source.getSourceId(), source, game, false, true);
                        continue;
                    }
                    Player player = game.getPlayer(targetId);
                    if (player == null) continue;
                    player.damage(amount, source.getSourceId(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    public FirestormEffect copy() {
        return new FirestormEffect(this);
    }
}

