/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.f.FirestormPhoenixRestrictEffect;
import mage.cards.f.FirestormPhoenixRevealEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FirestormPhoenixEffect
extends ReplacementEffectImpl {
    FirestormPhoenixEffect() {
        super(Duration.Custom, Outcome.ReturnToHand);
        this.staticText = "If {this} would die, return it to its owner's hand instead. Until that player's next turn, that player plays with that card revealed in their hand and can't play it";
    }

    private FirestormPhoenixEffect(FirestormPhoenixEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FirestormPhoenixEffect copy() {
        return new FirestormPhoenixEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        if (controller == null || permanent == null) {
            return false;
        }
        controller.moveCards((Card)permanent, Zone.HAND, source, game);
        Card card = game.getCard(permanent.getId());
        if (card == null) {
            return true;
        }
        game.addEffect(new FirestormPhoenixRevealEffect().setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        game.addEffect(new FirestormPhoenixRestrictEffect().setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getTargetId()) && ((ZoneChangeEvent)event).isDiesEvent();
    }
}

