/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class FirestormPhoenixRevealEffect
extends ContinuousEffectImpl {
    private int startingTurnNum;

    FirestormPhoenixRevealEffect() {
        super(Duration.Custom, Layer.PlayerEffects, SubLayer.NA, Outcome.Detriment);
    }

    private FirestormPhoenixRevealEffect(FirestormPhoenixRevealEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.startingTurnNum = effect.startingTurnNum;
    }

    public FirestormPhoenixRevealEffect copy() {
        return new FirestormPhoenixRevealEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.startingTurnNum = game.getTurnNum();
    }

    public boolean isInactive(Ability source, Game game) {
        if (game.getCard(this.getTargetPointer().getFirst(game, source)) == null) {
            return true;
        }
        return game.isActivePlayer(game.getOwnerId(this.getTargetPointer().getFirst(game, source))) && game.getTurnNum() > this.startingTurnNum;
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            this.discard();
            return false;
        }
        Player player = game.getPlayer(card.getOwnerId());
        if (player != null) {
            player.revealCards(card.getIdName(), (Cards)new CardsImpl(card), game, false);
        }
        return true;
    }
}

