/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.FishNoAbilityToken;
import mage.players.Player;

class FishersTalentLevel1Effect
extends OneShotEffect {
    FishersTalentLevel1Effect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. You may reveal it if it's a land card. Create a 1/1 blue Fish creature token if you revealed it this way. Then draw a card.";
    }

    private FishersTalentLevel1Effect(FishersTalentLevel1Effect effect) {
        super((OneShotEffect)effect);
    }

    public FishersTalentLevel1Effect copy() {
        return new FishersTalentLevel1Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card topCard = controller.getLibrary().getFromTop(game);
        if (topCard != null) {
            controller.lookAtCards("Top card of library", topCard, game);
            if (topCard.isLand(game) && controller.chooseUse(Outcome.PutCreatureInPlay, "Reveal " + topCard.getLogName() + " to create a 1/1 blue Fish creature token?", source, game)) {
                controller.revealCards(source, (Cards)new CardsImpl(topCard), game);
                new FishNoAbilityToken().putOntoBattlefield(1, game, source);
            }
        }
        controller.drawCards(1, source, game);
        return true;
    }
}

