/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class FishingPoleTriggeredAbility
extends TriggeredAbilityImpl {
    public FishingPoleTriggeredAbility(Zone zone, Effect effect, boolean optional) {
        super(zone, effect, optional);
        this.setTriggerPhrase("Whenever equipped creature becomes untapped, ");
    }

    protected FishingPoleTriggeredAbility(FishingPoleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FishingPoleTriggeredAbility copy() {
        return new FishingPoleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAPPED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent equipment = game.getPermanent(this.getSourceId());
        if (equipment == null || equipment.getAttachedTo() == null) {
            return false;
        }
        Permanent equipped = game.getPermanent(equipment.getAttachedTo());
        return equipped != null && event.getTargetId().equals(equipped.getId());
    }
}

