/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FlameblastDragonEffect
extends OneShotEffect {
    FlameblastDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}{R}. If you do, {this} deals X damage to any target";
    }

    private FlameblastDragonEffect(FlameblastDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ManaCostsImpl cost = new ManaCostsImpl("{X}{R}");
        if (player != null && player.chooseUse(Outcome.Damage, "Pay " + cost.getText() + "? If you do, Flameblast Dragon deals X damage to any target", source, game)) {
            int costX = player.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to damage)", game, source, true);
            cost.add((Object)new GenericManaCost(costX));
            if (cost.pay(source, game, source, source.getControllerId(), false, null)) {
                Permanent permanent = game.getPermanent(source.getFirstTarget());
                if (permanent != null) {
                    permanent.damage(costX, source.getSourceId(), source, game, false, true);
                    return true;
                }
                Player targetPlayer = game.getPlayer(source.getFirstTarget());
                if (targetPlayer != null) {
                    targetPlayer.damage(costX, source.getSourceId(), source, game);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public FlameblastDragonEffect copy() {
        return new FlameblastDragonEffect(this);
    }
}

