/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FlamerushRiderEffect
extends OneShotEffect {
    FlamerushRiderEffect() {
        super(Outcome.Copy);
        this.staticText = "create a token that's a copy of another target attacking creature and that's tapped and attacking. Exile the token at end of combat";
    }

    private FlamerushRiderEffect(FlamerushRiderEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlamerushRiderEffect copy() {
        return new FlamerushRiderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && permanent != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, true, 1, true, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.apply(game, source);
            for (Permanent addedToken : effect.getAddedPermanents()) {
                ExileTargetEffect exileEffect = new ExileTargetEffect();
                exileEffect.setTargetPointer((TargetPointer)new FixedTarget(addedToken, game));
                new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)exileEffect), false).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

