/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.condition.common.FerociousCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FlamesOfTheRazeBoarEffect
extends OneShotEffect {
    FlamesOfTheRazeBoarEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 4 damage to target creature an opponent controls. Then {this} deals 2 damage to each other creature that player controls if you control a creature with power 4 or greater.";
    }

    private FlamesOfTheRazeBoarEffect(FlamesOfTheRazeBoarEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlamesOfTheRazeBoarEffect copy() {
        return new FlamesOfTheRazeBoarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.damage(4, source.getSourceId(), source, game);
        if (!FerociousCondition.instance.apply(game, source)) {
            return true;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new ControllerIdPredicate(permanent.getControllerId()));
        filter.add(Predicates.not((Predicate)new PermanentIdPredicate(permanent.getId())));
        return new DamageAllEffect(2, (FilterPermanent)filter).apply(game, source);
    }
}

