/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FlayerEffect
extends OneShotEffect {
    FlayerEffect() {
        super(Outcome.Damage);
        this.staticText = "that creature deals damage equal to its power to any target";
    }

    private FlayerEffect(FlayerEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlayerEffect copy() {
        return new FlayerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID creatureId = (UUID)this.getValue("damageSource");
        Permanent creature = game.getPermanent(creatureId);
        if (creature == null) {
            creature = (Permanent)game.getLastKnownInformation(creatureId, Zone.BATTLEFIELD);
        }
        if (creature != null) {
            int amount = creature.getPower().getValue();
            UUID target = source.getTargets().getFirstTarget();
            Permanent targetCreature = game.getPermanent(target);
            if (targetCreature != null) {
                targetCreature.damage(amount, creature.getId(), source, game, false, true);
                return true;
            }
            Player player = game.getPlayer(target);
            if (player != null) {
                player.damage(amount, creature.getId(), source, game);
                return true;
            }
        }
        return false;
    }
}

