/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class FleetingReflectionEffect
extends OneShotEffect {
    FleetingReflectionEffect() {
        super(Outcome.Neutral);
        this.staticText = "Until end of turn, it becomes a copy of up to one other target creature";
    }

    private FleetingReflectionEffect(FleetingReflectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public FleetingReflectionEffect copy() {
        return new FleetingReflectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent copyTo = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent copyFrom = game.getPermanentOrLKIBattlefield(((Target)source.getTargets().get(1)).getFirstTarget());
        if (copyTo == null || copyFrom == null) {
            return false;
        }
        game.copyPermanent(Duration.EndOfTurn, copyFrom, copyTo.getId(), source, (CopyApplier)new EmptyCopyApplier());
        return true;
    }
}

