/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FleshAllergyWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FleshAllergyEffect
extends OneShotEffect {
    FleshAllergyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Its controller loses life equal to the number of creatures that died this turn";
    }

    private FleshAllergyEffect(FleshAllergyEffect effect) {
        super((OneShotEffect)effect);
    }

    public FleshAllergyEffect copy() {
        return new FleshAllergyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        Player player;
        FleshAllergyWatcher watcher = (FleshAllergyWatcher)game.getState().getWatcher(FleshAllergyWatcher.class);
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null && watcher != null && (player = game.getPlayer(permanent.getControllerId())) != null && (amount = watcher.getCreaturesDiedThisTurn()) > 0) {
            player.loseLife(amount, game, source, false);
            return true;
        }
        return false;
    }
}

