/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class FleshAllergyWatcher
extends Watcher {
    private int creaturesDiedThisTurn = 0;

    public FleshAllergyWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        MageObject card;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).isDiesEvent() && (card = game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && card.isCreature(game)) {
            ++this.creaturesDiedThisTurn;
        }
    }

    public int getCreaturesDiedThisTurn() {
        return this.creaturesDiedThisTurn;
    }

    public void reset() {
        super.reset();
        this.creaturesDiedThisTurn = 0;
    }
}

