/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class FleshEffect
extends OneShotEffect {
    FleshEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Exile target creature card from a graveyard. Put X +1/+1 counters on target creature, where X is the power of the card you exiled";
    }

    private FleshEffect(FleshEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature;
        Player player = game.getPlayer(source.getControllerId());
        Card targetCard = game.getCard(source.getFirstTarget());
        if (player == null || targetCard == null) {
            return false;
        }
        int power = targetCard.getPower().getValue();
        player.moveCards(targetCard, Zone.EXILED, source, game);
        if (power > 0 && (targetCreature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            targetCreature.addCounters(CounterType.P1P1.createInstance(power), source.getControllerId(), source, game);
        }
        return true;
    }

    public FleshEffect copy() {
        return new FleshEffect(this);
    }
}

