/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.common.ExileSourceFromGraveCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.MillCardsEachPlayerEffect;
import mage.abilities.effects.common.PutOnLibraryTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

public final class FlittingGuerrilla
extends CardImpl {
    private static final FilterCard filter = new FilterCard("creature or battle card from your graveyard");

    public FlittingGuerrilla(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{B}");
        this.subtype.add((Object)SubType.FAERIE);
        this.subtype.add((Object)SubType.ROGUE);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)FlyingAbility.getInstance());
        ReflexiveTriggeredAbility rAbility = new ReflexiveTriggeredAbility((Effect)new PutOnLibraryTargetEffect(true), false);
        rAbility.addTarget((Target)new TargetCardInYourGraveyard(filter));
        DiesSourceTriggeredAbility ability = new DiesSourceTriggeredAbility((Effect)new MillCardsEachPlayerEffect(2, TargetController.EACH_PLAYER));
        ability.addEffect((Effect)new DoWhenCostPaid(rAbility, new ExileSourceFromGraveCost().setText("exile {this}"), "Exile this from your graveyard?").concatBy("Then"));
        this.addAbility((Ability)ability);
    }

    private FlittingGuerrilla(FlittingGuerrilla card) {
        super((CardImpl)card);
    }

    public FlittingGuerrilla copy() {
        return new FlittingGuerrilla(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.BATTLE.getPredicate()));
    }
}

