/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.RabidSheepToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.util.CardUtil;

class FlockOfRabidSheepEffect
extends OneShotEffect {
    FlockOfRabidSheepEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Flip X coins. For each flip you win, create a 2/2 green Sheep creature token named Rabid Sheep";
    }

    private FlockOfRabidSheepEffect(FlockOfRabidSheepEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlockOfRabidSheepEffect copy() {
        return new FlockOfRabidSheepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int repeat = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            int wonCount = 0;
            for (int i = 1; i <= repeat; ++i) {
                if (!controller.flipCoin(source, game, true)) continue;
                ++wonCount;
            }
            new CreateTokenEffect((Token)new RabidSheepToken(), wonCount).apply(game, source);
            return true;
        }
        return false;
    }
}

