/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.watchers.common.PlayerLostLifeWatcher;

class FlorianVoldarenScionEffect
extends OneShotEffect {
    FlorianVoldarenScionEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top X cards of your library, where X is the total amount of life your opponents lost this turn. Exile one of those cards and put the rest on the bottom of your library in a random order. You may play the exiled card this turn";
    }

    private FlorianVoldarenScionEffect(FlorianVoldarenScionEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlorianVoldarenScionEffect copy() {
        return new FlorianVoldarenScionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards;
        int numCards;
        int lifeLost;
        Player controller = game.getPlayer(source.getControllerId());
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        if (controller != null && watcher != null && (lifeLost = watcher.getAllOppLifeLost(controller.getId(), game)) > 0 && (numCards = (cards = new CardsImpl(controller.getLibrary().getTopCards(game, lifeLost))).size()) > 0) {
            Card selectedCard;
            controller.lookAtCards(source, null, (Cards)cards, game);
            if (numCards == 1) {
                selectedCard = game.getCard((UUID)cards.iterator().next());
            } else {
                TargetCard target = new TargetCard(Zone.LIBRARY, StaticFilters.FILTER_CARD);
                controller.chooseTarget(this.outcome, (Cards)cards, target, source, game);
                selectedCard = game.getCard(target.getFirstTarget());
            }
            if (selectedCard != null) {
                cards.remove(selectedCard);
                PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Card)selectedCard, (TargetController)TargetController.YOU, (Duration)Duration.EndOfTurn, (boolean)false, (boolean)false, (boolean)false);
            }
            if (!cards.isEmpty()) {
                controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
            }
            return true;
        }
        return false;
    }
}

